/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.PlatformDescriptors;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DebugOverlayGui
extends AbstractGui {
    private static final Map<Heightmap.Type, String> field_212923_a = Util.func_200696_a(new EnumMap(Heightmap.Type.class), p_212918_0_ -> {
        p_212918_0_.put(Heightmap.Type.WORLD_SURFACE_WG, "SW");
        p_212918_0_.put(Heightmap.Type.WORLD_SURFACE, "S");
        p_212918_0_.put(Heightmap.Type.OCEAN_FLOOR_WG, "OW");
        p_212918_0_.put(Heightmap.Type.OCEAN_FLOOR, "O");
        p_212918_0_.put(Heightmap.Type.MOTION_BLOCKING, "M");
        p_212918_0_.put(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft field_175242_a;
    private final FontRenderer field_175241_f;
    protected RayTraceResult field_211537_g;
    protected RayTraceResult field_211538_h;
    @Nullable
    private ChunkPos field_212924_f;
    @Nullable
    private Chunk field_212925_g;
    @Nullable
    private CompletableFuture<Chunk> field_212926_h;

    public DebugOverlayGui(Minecraft p_i45543_1_) {
        this.field_175242_a = p_i45543_1_;
        this.field_175241_f = p_i45543_1_.field_71466_p;
    }

    public void func_212921_a() {
        this.field_212926_h = null;
        this.field_212925_g = null;
    }

    public void func_194818_a(MatrixStack p_194818_1_) {
        this.field_175242_a.func_213239_aq().func_76320_a("debug");
        RenderSystem.pushMatrix();
        Entity entity = this.field_175242_a.func_175606_aa();
        this.field_211537_g = entity.func_213324_a(20.0, 0.0f, false);
        this.field_211538_h = entity.func_213324_a(20.0, 0.0f, true);
        this.func_230024_c_(p_194818_1_);
        this.func_230025_d_(p_194818_1_);
        RenderSystem.popMatrix();
        if (this.field_175242_a.field_71474_y.field_181657_aC) {
            int i = this.field_175242_a.func_228018_at_().func_198107_o();
            this.func_238509_a_(p_194818_1_, this.field_175242_a.func_181539_aj(), 0, i / 2, true);
            IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
            if (integratedserver != null) {
                this.func_238509_a_(p_194818_1_, integratedserver.func_213210_aR(), i - Math.min(i / 2, 240), i / 2, false);
            }
        }
        this.field_175242_a.func_213239_aq().func_76319_b();
    }

    protected void func_230024_c_(MatrixStack p_230024_1_) {
        List<String> list = this.func_209011_c();
        list.add("");
        boolean flag = this.field_175242_a.func_71401_C() != null;
        list.add("Debug: Pie [shift]: " + (this.field_175242_a.field_71474_y.field_74329_Q ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.field_175242_a.field_71474_y.field_181657_aC ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.field_175241_f.func_78256_a(s);
            int l = 2;
            int i1 = 2 + j * i;
            DebugOverlayGui.func_238467_a_((MatrixStack)p_230024_1_, (int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.field_175241_f.func_238421_b_(p_230024_1_, s, 2.0f, (float)i1, 0xE0E0E0);
        }
    }

    protected void func_230025_d_(MatrixStack p_230025_1_) {
        List<String> list = this.func_175238_c();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.field_175241_f.func_78256_a(s);
            int l = this.field_175242_a.func_228018_at_().func_198107_o() - 2 - k;
            int i1 = 2 + j * i;
            DebugOverlayGui.func_238467_a_((MatrixStack)p_230025_1_, (int)(l - 1), (int)(i1 - 1), (int)(l + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.field_175241_f.func_238421_b_(p_230025_1_, s, (float)l, (float)i1, 0xE0E0E0);
        }
    }

    protected List<String> func_209011_c() {
        ShaderGroup shadergroup;
        World world;
        String s1;
        IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
        NetworkManager networkmanager = this.field_175242_a.func_147114_u().func_147298_b();
        float f = networkmanager.func_211390_n();
        float f1 = networkmanager.func_211393_m();
        String s = integratedserver != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedserver.func_211149_aT()), Float.valueOf(f), Float.valueOf(f1)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.field_175242_a.field_71439_g.func_142021_k(), Float.valueOf(f), Float.valueOf(f1));
        BlockPos blockpos = this.field_175242_a.func_175606_aa().func_233580_cy_();
        if (this.field_175242_a.func_189648_am()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ")", this.field_175242_a.field_71426_K, s, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u(), "", String.format("Chunk-relative: %d %d %d", blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF)});
        }
        Entity entity = this.field_175242_a.func_175606_aa();
        Direction direction = entity.func_174811_aO();
        switch (direction) {
            case NORTH: {
                s1 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                s1 = "Towards positive Z";
                break;
            }
            case WEST: {
                s1 = "Towards negative X";
                break;
            }
            case EAST: {
                s1 = "Towards positive X";
                break;
            }
            default: {
                s1 = "Invalid";
            }
        }
        ChunkPos chunkpos = new ChunkPos(blockpos);
        if (!Objects.equals(this.field_212924_f, chunkpos)) {
            this.field_212924_f = chunkpos;
            this.func_212921_a();
        }
        LongSets.EmptySet longset = (world = this.func_212922_g()) instanceof ServerWorld ? ((ServerWorld)world).func_217469_z() : LongSets.EMPTY_SET;
        ArrayList list = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_175242_a.func_184123_d()) ? "" : "/" + this.field_175242_a.func_184123_d()) + ")", this.field_175242_a.field_71426_K, s, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u()});
        String s2 = this.func_223101_g();
        if (s2 != null) {
            list.add(s2);
        }
        list.add(this.field_175242_a.field_71441_e.func_234923_W_().func_240901_a_() + " FC: " + longset.size());
        list.add("");
        list.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.field_175242_a.func_175606_aa().func_226277_ct_(), this.field_175242_a.func_175606_aa().func_226278_cu_(), this.field_175242_a.func_175606_aa().func_226281_cx_()));
        list.add(String.format("Block: %d %d %d", blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()));
        list.add(String.format("Chunk: %d %d %d in %d %d %d", blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF, blockpos.func_177958_n() >> 4, blockpos.func_177956_o() >> 4, blockpos.func_177952_p() >> 4));
        list.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", new Object[]{direction, s1, Float.valueOf(MathHelper.func_76142_g((float)entity.field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)entity.field_70125_A))}));
        if (this.field_175242_a.field_71441_e != null) {
            if (this.field_175242_a.field_71441_e.func_175667_e(blockpos)) {
                Chunk chunk = this.func_212916_i();
                if (chunk.func_76621_g()) {
                    list.add("Waiting for chunk...");
                } else {
                    int i = this.field_175242_a.field_71441_e.func_72863_F().func_212863_j_().func_227470_b_(blockpos, 0);
                    int j = this.field_175242_a.field_71441_e.func_226658_a_(LightType.SKY, blockpos);
                    int k = this.field_175242_a.field_71441_e.func_226658_a_(LightType.BLOCK, blockpos);
                    list.add("Client Light: " + i + " (" + j + " sky, " + k + " block)");
                    Chunk chunk1 = this.func_212919_h();
                    if (chunk1 != null) {
                        WorldLightManager worldlightmanager = world.func_72863_F().func_212863_j_();
                        list.add("Server Light: (" + worldlightmanager.func_215569_a(LightType.SKY).func_215611_b(blockpos) + " sky, " + worldlightmanager.func_215569_a(LightType.BLOCK).func_215611_b(blockpos) + " block)");
                    } else {
                        list.add("Server Light: (?? sky, ?? block)");
                    }
                    StringBuilder stringbuilder = new StringBuilder("CH");
                    for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
                        if (!heightmap$type.func_222681_b()) continue;
                        stringbuilder.append(" ").append(field_212923_a.get(heightmap$type)).append(": ").append(chunk.func_201576_a(heightmap$type, blockpos.func_177958_n(), blockpos.func_177952_p()));
                    }
                    list.add(stringbuilder.toString());
                    stringbuilder.setLength(0);
                    stringbuilder.append("SH");
                    for (Heightmap.Type heightmap$type1 : Heightmap.Type.values()) {
                        if (!heightmap$type1.func_222683_c()) continue;
                        stringbuilder.append(" ").append(field_212923_a.get(heightmap$type1)).append(": ");
                        if (chunk1 != null) {
                            stringbuilder.append(chunk1.func_201576_a(heightmap$type1, blockpos.func_177958_n(), blockpos.func_177952_p()));
                            continue;
                        }
                        stringbuilder.append("??");
                    }
                    list.add(stringbuilder.toString());
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256) {
                        list.add("Biome: " + this.field_175242_a.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.field_175242_a.field_71441_e.func_226691_t_(blockpos)));
                        long i1 = 0L;
                        float f2 = 0.0f;
                        if (chunk1 != null) {
                            f2 = world.func_242413_ae();
                            i1 = chunk1.func_177416_w();
                        }
                        DifficultyInstance difficultyinstance = new DifficultyInstance(world.func_175659_aa(), world.func_72820_D(), i1, f2);
                        list.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyinstance.func_180168_b()), Float.valueOf(difficultyinstance.func_180170_c()), this.field_175242_a.field_71441_e.func_72820_D() / 24000L));
                    }
                }
            } else {
                list.add("Outside of world...");
            }
        } else {
            list.add("Outside of world...");
        }
        ServerWorld serverworld = this.func_238515_d_();
        if (serverworld != null) {
            WorldEntitySpawner.EntityDensityManager worldentityspawner$entitydensitymanager = serverworld.func_72863_F().func_241101_k_();
            if (worldentityspawner$entitydensitymanager != null) {
                Object2IntMap<EntityClassification> object2intmap = worldentityspawner$entitydensitymanager.func_234995_b_();
                int l = worldentityspawner$entitydensitymanager.func_234988_a_();
                list.add("SC: " + l + ", " + Stream.of(EntityClassification.values()).map(p_238511_1_ -> Character.toUpperCase(p_238511_1_.func_220363_a().charAt(0)) + ": " + object2intmap.getInt((Object)p_238511_1_)).collect(Collectors.joining(", ")));
            } else {
                list.add("SC: N/A");
            }
        }
        if ((shadergroup = this.field_175242_a.field_71460_t.func_147706_e()) != null) {
            list.add("Shader: " + shadergroup.func_148022_b());
        }
        list.add(this.field_175242_a.func_147118_V().func_215293_f() + String.format(" (Mood %d%%)", Math.round(this.field_175242_a.field_71439_g.func_239206_w_() * 100.0f)));
        return list;
    }

    @Nullable
    private ServerWorld func_238515_d_() {
        IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
        return integratedserver != null ? integratedserver.func_71218_a(this.field_175242_a.field_71441_e.func_234923_W_()) : null;
    }

    @Nullable
    private String func_223101_g() {
        ServerWorld serverworld = this.func_238515_d_();
        return serverworld != null ? serverworld.func_72827_u() : null;
    }

    private World func_212922_g() {
        return (World)DataFixUtils.orElse(Optional.ofNullable(this.field_175242_a.func_71401_C()).flatMap(p_212917_1_ -> Optional.ofNullable(p_212917_1_.func_71218_a(this.field_175242_a.field_71441_e.func_234923_W_()))), (Object)this.field_175242_a.field_71441_e);
    }

    @Nullable
    private Chunk func_212919_h() {
        if (this.field_212926_h == null) {
            ServerWorld serverworld = this.func_238515_d_();
            if (serverworld != null) {
                this.field_212926_h = serverworld.func_72863_F().func_217232_b(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b, ChunkStatus.field_222617_m, false).thenApply(p_222802_0_ -> (Chunk)p_222802_0_.map(p_222803_0_ -> (Chunk)p_222803_0_, p_222801_0_ -> null));
            }
            if (this.field_212926_h == null) {
                this.field_212926_h = CompletableFuture.completedFuture(this.func_212916_i());
            }
        }
        return this.field_212926_h.getNow(null);
    }

    private Chunk func_212916_i() {
        if (this.field_212925_g == null) {
            this.field_212925_g = this.field_175242_a.field_71441_e.func_212866_a_(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b);
        }
        return this.field_212925_g;
    }

    protected List<String> func_175238_c() {
        Entity entity;
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        ArrayList list = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.field_175242_a.func_147111_S() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, DebugOverlayGui.func_175240_a(l), DebugOverlayGui.func_175240_a(i)), String.format("Allocated: % 2d%% %03dMB", j * 100L / i, DebugOverlayGui.func_175240_a(j)), "", String.format("CPU: %s", PlatformDescriptors.func_227775_b_()), "", String.format("Display: %dx%d (%s)", Minecraft.func_71410_x().func_228018_at_().func_198109_k(), Minecraft.func_71410_x().func_228018_at_().func_198091_l(), PlatformDescriptors.func_227774_a_()), PlatformDescriptors.func_227776_c_(), PlatformDescriptors.func_227777_d_()});
        if (this.field_175242_a.func_189648_am()) {
            return list;
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            BlockState blockstate = this.field_175242_a.field_71441_e.func_180495_p(blockpos);
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Block: " + blockpos.func_177958_n() + ", " + blockpos.func_177956_o() + ", " + blockpos.func_177952_p());
            list.add(String.valueOf(Registry.field_212618_g.func_177774_c((Object)blockstate.func_177230_c())));
            for (Map.Entry entry : blockstate.func_206871_b().entrySet()) {
                list.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourcelocation : blockstate.func_177230_c().getTags()) {
                list.add("#" + resourcelocation);
            }
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            FluidState fluidstate = this.field_175242_a.field_71441_e.func_204610_c(blockpos1);
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Fluid: " + blockpos1.func_177958_n() + ", " + blockpos1.func_177956_o() + ", " + blockpos1.func_177952_p());
            list.add(String.valueOf(Registry.field_212619_h.func_177774_c((Object)fluidstate.func_206886_c())));
            for (Map.Entry entry1 : fluidstate.func_206871_b().entrySet()) {
                list.add(this.func_211534_a(entry1));
            }
            for (ResourceLocation resourcelocation1 : fluidstate.func_206886_c().getTags()) {
                list.add("#" + resourcelocation1);
            }
        }
        if ((entity = this.field_175242_a.field_147125_j) != null) {
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Entity");
            list.add(String.valueOf(Registry.field_212629_r.func_177774_c(entity.func_200600_R())));
            entity.func_200600_R().getTags().forEach(t -> list.add("#" + t));
        }
        return list;
    }

    private String func_211534_a(Map.Entry<Property<?>, Comparable<?>> p_211534_1_) {
        Property<?> property = p_211534_1_.getKey();
        Comparable<?> comparable = p_211534_1_.getValue();
        String s = Util.func_200269_a(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = TextFormatting.GREEN + s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = TextFormatting.RED + s;
        }
        return property.func_177701_a() + ": " + s;
    }

    private void func_238509_a_(MatrixStack p_238509_1_, FrameTimer p_238509_2_, int p_238509_3_, int p_238509_4_, boolean p_238509_5_) {
        RenderSystem.disableDepthTest();
        int i = p_238509_2_.func_181749_a();
        int j = p_238509_2_.func_181750_b();
        long[] along = p_238509_2_.func_181746_c();
        int l = p_238509_3_;
        int i1 = Math.max(0, along.length - p_238509_4_);
        int j1 = along.length - i1;
        int lvt_9_1_ = p_238509_2_.func_181751_b(i + i1);
        long k1 = 0L;
        int l1 = Integer.MAX_VALUE;
        int i2 = Integer.MIN_VALUE;
        for (int j2 = 0; j2 < j1; ++j2) {
            int k2 = (int)(along[p_238509_2_.func_181751_b(lvt_9_1_ + j2)] / 1000000L);
            l1 = Math.min(l1, k2);
            i2 = Math.max(i2, k2);
            k1 += (long)k2;
        }
        int k4 = this.field_175242_a.func_228018_at_().func_198087_p();
        DebugOverlayGui.func_238467_a_((MatrixStack)p_238509_1_, (int)p_238509_3_, (int)(k4 - 60), (int)(p_238509_3_ + j1), (int)k4, (int)-1873784752);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = TransformationMatrix.func_227983_a_().func_227988_c_();
        while (lvt_9_1_ != j) {
            int l2 = p_238509_2_.func_219792_a(along[lvt_9_1_], p_238509_5_ ? 30 : 60, p_238509_5_ ? 60 : 20);
            int i3 = p_238509_5_ ? 100 : 60;
            int j3 = this.func_181552_c(MathHelper.func_76125_a((int)l2, (int)0, (int)i3), 0, i3 / 2, i3);
            int k3 = j3 >> 24 & 0xFF;
            int l3 = j3 >> 16 & 0xFF;
            int i4 = j3 >> 8 & 0xFF;
            int j4 = j3 & 0xFF;
            bufferbuilder.func_227888_a_(matrix4f, l + 1, k4, 0.0f).func_225586_a_(l3, i4, j4, k3).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, l + 1, k4 - l2 + 1, 0.0f).func_225586_a_(l3, i4, j4, k3).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, l, k4 - l2 + 1, 0.0f).func_225586_a_(l3, i4, j4, k3).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, l, k4, 0.0f).func_225586_a_(l3, i4, j4, k3).func_181675_d();
            ++l;
            lvt_9_1_ = p_238509_2_.func_181751_b(lvt_9_1_ + 1);
        }
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        if (p_238509_5_) {
            DebugOverlayGui.func_238467_a_((MatrixStack)p_238509_1_, (int)(p_238509_3_ + 1), (int)(k4 - 30 + 1), (int)(p_238509_3_ + 14), (int)(k4 - 30 + 10), (int)-1873784752);
            this.field_175241_f.func_238421_b_(p_238509_1_, "60 FPS", (float)(p_238509_3_ + 2), (float)(k4 - 30 + 2), 0xE0E0E0);
            this.func_238465_a_(p_238509_1_, p_238509_3_, p_238509_3_ + j1 - 1, k4 - 30, -1);
            DebugOverlayGui.func_238467_a_((MatrixStack)p_238509_1_, (int)(p_238509_3_ + 1), (int)(k4 - 60 + 1), (int)(p_238509_3_ + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.field_175241_f.func_238421_b_(p_238509_1_, "30 FPS", (float)(p_238509_3_ + 2), (float)(k4 - 60 + 2), 0xE0E0E0);
            this.func_238465_a_(p_238509_1_, p_238509_3_, p_238509_3_ + j1 - 1, k4 - 60, -1);
        } else {
            DebugOverlayGui.func_238467_a_((MatrixStack)p_238509_1_, (int)(p_238509_3_ + 1), (int)(k4 - 60 + 1), (int)(p_238509_3_ + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.field_175241_f.func_238421_b_(p_238509_1_, "20 TPS", (float)(p_238509_3_ + 2), (float)(k4 - 60 + 2), 0xE0E0E0);
            this.func_238465_a_(p_238509_1_, p_238509_3_, p_238509_3_ + j1 - 1, k4 - 60, -1);
        }
        this.func_238465_a_(p_238509_1_, p_238509_3_, p_238509_3_ + j1 - 1, k4 - 1, -1);
        this.func_238473_b_(p_238509_1_, p_238509_3_, k4 - 60, k4, -1);
        this.func_238473_b_(p_238509_1_, p_238509_3_ + j1 - 1, k4 - 60, k4, -1);
        if (p_238509_5_ && this.field_175242_a.field_71474_y.field_74350_i > 0 && this.field_175242_a.field_71474_y.field_74350_i <= 250) {
            this.func_238465_a_(p_238509_1_, p_238509_3_, p_238509_3_ + j1 - 1, k4 - 1 - (int)(1800.0 / (double)this.field_175242_a.field_71474_y.field_74350_i), -16711681);
        }
        String s = l1 + " ms min";
        String s1 = k1 / (long)j1 + " ms avg";
        String s2 = i2 + " ms max";
        this.field_175241_f.func_238405_a_(p_238509_1_, s, (float)(p_238509_3_ + 2), (float)(k4 - 60 - 9), 0xE0E0E0);
        this.field_175241_f.func_238405_a_(p_238509_1_, s1, (float)(p_238509_3_ + j1 / 2 - this.field_175241_f.func_78256_a(s1) / 2), (float)(k4 - 60 - 9), 0xE0E0E0);
        this.field_175241_f.func_238405_a_(p_238509_1_, s2, (float)(p_238509_3_ + j1 - this.field_175241_f.func_78256_a(s2)), (float)(k4 - 60 - 9), 0xE0E0E0);
        RenderSystem.enableDepthTest();
    }

    private int func_181552_c(int p_181552_1_, int p_181552_2_, int p_181552_3_, int p_181552_4_) {
        return p_181552_1_ < p_181552_3_ ? this.func_181553_a(-16711936, -256, (float)p_181552_1_ / (float)p_181552_3_) : this.func_181553_a(-256, -65536, (float)(p_181552_1_ - p_181552_3_) / (float)(p_181552_4_ - p_181552_3_));
    }

    private int func_181553_a(int p_181553_1_, int p_181553_2_, float p_181553_3_) {
        int i = p_181553_1_ >> 24 & 0xFF;
        int j = p_181553_1_ >> 16 & 0xFF;
        int k = p_181553_1_ >> 8 & 0xFF;
        int l = p_181553_1_ & 0xFF;
        int i1 = p_181553_2_ >> 24 & 0xFF;
        int j1 = p_181553_2_ >> 16 & 0xFF;
        int k1 = p_181553_2_ >> 8 & 0xFF;
        int l1 = p_181553_2_ & 0xFF;
        int i2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)p_181553_3_, (float)i, (float)i1)), (int)0, (int)255);
        int j2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)p_181553_3_, (float)j, (float)j1)), (int)0, (int)255);
        int k2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)p_181553_3_, (float)k, (float)k1)), (int)0, (int)255);
        int l2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)p_181553_3_, (float)l, (float)l1)), (int)0, (int)255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }

    private static long func_175240_a(long p_175240_0_) {
        return p_175240_0_ / 1024L / 1024L;
    }
}

